/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v118.runtime.model;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class SerializationOptions {
    private final Serialization serialization;
    private final Optional<Integer> maxDepth;
    private final Optional<Map<String, Object>> additionalParameters;

    public SerializationOptions(Serialization serialization, Optional<Integer> maxDepth, Optional<Map<String, Object>> additionalParameters) {
        this.serialization = Objects.requireNonNull(serialization, "serialization is required");
        this.maxDepth = maxDepth;
        this.additionalParameters = additionalParameters;
    }

    public Serialization getSerialization() {
        return this.serialization;
    }

    public Optional<Integer> getMaxDepth() {
        return this.maxDepth;
    }

    public Optional<Map<String, Object>> getAdditionalParameters() {
        return this.additionalParameters;
    }

    private static SerializationOptions fromJson(JsonInput input) {
        Serialization serialization = null;
        Optional<Integer> maxDepth = Optional.empty();
        Optional<Map<String, Object>> additionalParameters = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "serialization": {
                    serialization = Serialization.fromString(input.nextString());
                    continue block10;
                }
                case "maxDepth": {
                    maxDepth = Optional.ofNullable(input.nextNumber().intValue());
                    continue block10;
                }
                case "additionalParameters": {
                    additionalParameters = Optional.ofNullable((Map)input.read(Map.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SerializationOptions(serialization, maxDepth, additionalParameters);
    }

    public static enum Serialization {
        DEEP("deep"),
        JSON("json"),
        IDONLY("idOnly");

        private String value;

        private Serialization(String value) {
            this.value = value;
        }

        public static Serialization fromString(String s) {
            return Arrays.stream(Serialization.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Serialization "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Serialization fromJson(JsonInput input) {
            return Serialization.fromString(input.nextString());
        }
    }
}

