package org.openqa.selenium.devtools.v85.webauthn.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class VirtualAuthenticatorOptions {

    private final org.openqa.selenium.devtools.v85.webauthn.model.AuthenticatorProtocol protocol;

    private final org.openqa.selenium.devtools.v85.webauthn.model.AuthenticatorTransport transport;

    private final java.util.Optional<java.lang.Boolean> hasResidentKey;

    private final java.util.Optional<java.lang.Boolean> hasUserVerification;

    private final java.util.Optional<java.lang.Boolean> automaticPresenceSimulation;

    private final java.util.Optional<java.lang.Boolean> isUserVerified;

    public VirtualAuthenticatorOptions(org.openqa.selenium.devtools.v85.webauthn.model.AuthenticatorProtocol protocol, org.openqa.selenium.devtools.v85.webauthn.model.AuthenticatorTransport transport, java.util.Optional<java.lang.Boolean> hasResidentKey, java.util.Optional<java.lang.Boolean> hasUserVerification, java.util.Optional<java.lang.Boolean> automaticPresenceSimulation, java.util.Optional<java.lang.Boolean> isUserVerified) {
        this.protocol = java.util.Objects.requireNonNull(protocol, "protocol is required");
        this.transport = java.util.Objects.requireNonNull(transport, "transport is required");
        this.hasResidentKey = hasResidentKey;
        this.hasUserVerification = hasUserVerification;
        this.automaticPresenceSimulation = automaticPresenceSimulation;
        this.isUserVerified = isUserVerified;
    }

    public org.openqa.selenium.devtools.v85.webauthn.model.AuthenticatorProtocol getProtocol() {
        return protocol;
    }

    public org.openqa.selenium.devtools.v85.webauthn.model.AuthenticatorTransport getTransport() {
        return transport;
    }

    /**
     * Defaults to false.
     */
    public java.util.Optional<java.lang.Boolean> getHasResidentKey() {
        return hasResidentKey;
    }

    /**
     * Defaults to false.
     */
    public java.util.Optional<java.lang.Boolean> getHasUserVerification() {
        return hasUserVerification;
    }

    /**
     * If set to true, tests of user presence will succeed immediately.
     * Otherwise, they will not be resolved. Defaults to true.
     */
    public java.util.Optional<java.lang.Boolean> getAutomaticPresenceSimulation() {
        return automaticPresenceSimulation;
    }

    /**
     * Sets whether User Verification succeeds or fails for an authenticator.
     * Defaults to false.
     */
    public java.util.Optional<java.lang.Boolean> getIsUserVerified() {
        return isUserVerified;
    }

    private static VirtualAuthenticatorOptions fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v85.webauthn.model.AuthenticatorProtocol protocol = null;
        org.openqa.selenium.devtools.v85.webauthn.model.AuthenticatorTransport transport = null;
        java.util.Optional<java.lang.Boolean> hasResidentKey = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> hasUserVerification = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> automaticPresenceSimulation = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> isUserVerified = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "protocol":
                    protocol = input.read(org.openqa.selenium.devtools.v85.webauthn.model.AuthenticatorProtocol.class);
                    break;
                case "transport":
                    transport = input.read(org.openqa.selenium.devtools.v85.webauthn.model.AuthenticatorTransport.class);
                    break;
                case "hasResidentKey":
                    hasResidentKey = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "hasUserVerification":
                    hasUserVerification = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "automaticPresenceSimulation":
                    automaticPresenceSimulation = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "isUserVerified":
                    isUserVerified = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new VirtualAuthenticatorOptions(protocol, transport, hasResidentKey, hasUserVerification, automaticPresenceSimulation, isUserVerified);
    }
}
